; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below.
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 3


;-| Super Motions |--------------------------------------------------------
;
[Command]
name = "TripleKFPalm"
command = ~45$B, $F, $B, $F, x
time = 20

[Command]
name = "TripleKFPalm"   ;Same name as above
command = ~45$B, $F, $B, $F, y
time = 20

[Command]
name = "TripleKFPalm"   ;Same name as above
command = ~45$B, $F, $B, $F, z
time = 20

[Command]
name = "SmashKFUpper"
command = ~D, DB, B, D, DB, x;~F, D, DF, F, D, DF, x
time = 20

[Command]
name = "SmashKFUpper"   ;Same name as above
command = ~D, DB, B, D, DB, y;~F, D, DF, F, D, DF, y
time = 20

[Command]
name = "SmashKFUpper"   ;Same name as above
command = ~D, DB, B, D, DB, z;~F, D, DF, F, D, DF, y
time = 20

[Command]
name = "reppa"   ;Same name as above
command = ~D, DF, F, D, DF, F, a
time = 20

[Command]
name = "reppa"   ;Same name as above
command = ~D, DF, F, D, DF, F, b
time = 20

[Command]
name = "reppa"   ;Same name as above
command = ~D, DF, F, D, DF, F, c
time = 20

;-| Special Motions |------------------------------------------------------
[Command]
name = "blocking"
command = $F,x
time = 3

[Command]
name = "blocking" ;Same name as above (buttons in opposite order)
command = x,$F
time = 3

[Command]
name = "upper_x"
command = ~F, D, DF, x

[Command]
name = "upper_y"
command = ~F, D, DF, y

[Command]
name = "upper_z"
command = ~F, D, DF, z

[Command]
name = "upper_a"
command = ~F, D, DF, a

[Command]
name = "upper_b"
command = ~F, D, DF, b

[Command]
name = "upper_c"
command = ~F, D, DF, c

[Command]
name = "RDP_a"
command = ~B, D, DB, a

[Command]
name = "RDP_b"
command = ~B, D, DB, a

[Command]
name = "RDP_c"
command = ~B, D, DB, c

[Command]
name = "BF_a"
command = ~45$B, $F, a
time = 10

[Command]
name = "BF_b"
command = ~45$B, $F, b
time = 10

[Command]
name = "BF_c"
command = ~45$B, $F, c
time = 10

[Command]
name = "BF_x"
command = ~45$B, $F, x
time = 10

[Command]
name = "BF_y"
command = ~45$B, $F, y
time = 10

[Command]
name = "BF_z"
command = ~45$B, $F, z
time = 10

[Command]
name = "BF_t"
command = ~45$B, $F, z+c
time = 10

[Command]
name = "FB_x"
command = ~60$F, $B, x
time = 10

[Command]
name = "FB_y"
command = ~60$F, $B, y
time = 10

[Command]
name = "FB_z"
command = ~60$F, $B, z
time = 10

[Command]
name = "DU_x"
command = ~45$D, $U, x
time = 10

[Command]
name = "DU_y"
command = ~45$D, $U, y
time = 10

[Command]
name = "DU_z"
command = ~45$D, $U, z
time = 10

[Command]
name = "QCF_x"
command = ~D, DF, F, x

[Command]
name = "QCF_y"
command = ~D, DF, F, y

[Command]
name = "QCF_z"
command = ~D, DF, F, z

[Command]
name = "QCF_xy"
command = ~D, DF, F, x+y

[Command]
name = "QCB_x"
command = ~D, DB, B, x

[Command]
name = "QCB_y"
command = ~D, DB, B, y

[Command]
name = "QCB_xy"
command = ~D, DB, B, x+y

[Command]
name = "QCF_a"
command = ~D, DF, F, a

[Command]
name = "QCF_b"
command = ~D, DF, F, b

[Command]
name = "QCF_ab"
command = ~D, DF, F, a+b

[Command]
name = "FF_ab"
command = F, F, a+b

[Command]
name = "FF_a"
command = F, F, a

[Command]
name = "FF_b"
command = F, F, b

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

[Command]
name = "SJ"     ;Required (do not remove)
command = $D, $U

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

[Command]
name = "throw"
command = x+a
time = 1

[Command]
name = "mask"
command = y+b
time = 1

[Command]
name = "taunt"
command = z+c
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "JD"
command = /$B
time = 1
buffer.time = 4

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

[Command]
name = "back"     ; REQUIRED for command buffering
command = B
time = 1

[Command]
name = "fwd"      ; REQUIRED for command buffering
command = F
time = 1

[Command]
name = "up"       ; REQUIRED for command buffering
command = U
time = 1

[Command]
name = "down"     ; REQUIRED for command buffering
command = D
time = 1

[Command]
name = "downback" ; REQUIRED for command buffering
command = DB
time = 1

[Command]
name = "downfwd"  ; REQUIRED for command buffering
command = DF
time = 1

[Command]
name = "fwd2"     ; REQUIRED for command buffering
command = $F
time = 1

[Command]
name = "back2"    ; REQUIRED for command buffering
command = $B
time = 1

[Command]
name = "up2"
command = $U      ; REQUIRED for command buffering
time = 1

[Command]
name = "down2"    ; REQUIRED for command buffering
command = $D
time = 1


;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[Command]
name = "holdfwd_r" ; Raw hold forward (REQUIRED for command buffering)
command = /F
time = 1
[Command]
name = "holddown_r" ; Raw hold forward (REQUIRED for command buffering)
command = /D
time = 1
[Command]
name = "holdback_r" ; Raw hold forward (REQUIRED for command buffering)
command = /B
time = 1
[Command]
name = "holdup_r" ; Raw hold forward (REQUIRED for command buffering)
command = /U
time = 1

;-| Hold Button |-----------------------------------------------------------
[Command]
name = "hold_a"
command = /a
time = 1
 
[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1
 
[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "hold_start"
command = /s
time = 1

[Command]
name = "hold_kick"
command = /a
time = 1

[Command]
name = "hold_kick"
command = /b
time = 1

[Command]
name = "hold_kick"
command = /c
time = 1

;-| Release Dir |-----------------------------------------------------------
[Command]
name = "release_fwd"
command = ~F
time = 1

[Command]
name = "release_down"
command = ~D
time = 1

[Command]
name = "release_back"
command = ~B
time = 1

[Command]
name = "release_up"
command = ~U
time = 1

[Command]
name = "release_fwd_g"    ; REQUIRED for command buffering
command = ~$F
time = 1

[Command]
name = "release_down_g"   ; REQUIRED for command buffering
command = ~$D
time = 1

[Command]
name = "release_back_g"   ; REQUIRED for command buffering
command = ~$B
time = 1

[Command]
name = "release_up_g"     ; REQUIRED for command buffering
command = ~$U
time = 1

[Command]
name = "release_downback" ; REQUIRED for command buffering
command = ~DB
time = 1

[Command]
name = "release_downfwd"  ; REQUIRED for command buffering
command = ~DF
time = 1

;-| Release Button |---------------------------------------------------------
[Command]
name = "release_a"
command = ~a
time = 1

[Command]
name = "release_b"
command = ~b
time = 1

[Command]
name = "release_c"
command = ~c
time = 1

[Command]
name = "release_x"
command = ~x
time = 1

[Command]
name = "release_y"
command = ~y
time = 1

[Command]
name = "release_z"
command = ~z
time = 1

[Command]
name = "release_start"
command = ~s
time = 1
;#endregion

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================

;---------------------------------------------------------------------------
;Smash Kung Fu Upper (uses one super bar)
[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 3100
triggerall = command = "reppa"
triggerall = power >= 1000
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [3100,3199]
trigger2 = movecontact
trigger3 = stateno = 1310 || stateno = 1330 ;From blocking
trigger4 = stateno = 1120
trigger4 = animelemtime(4) > 0

;---------------------------------------------------------------------------
;Smash Kung Fu Upper (uses one super bar)
[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 3050
triggerall = command = "SmashKFUpper"
triggerall = power >= 1000
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [3050,3059]
trigger2 = movecontact
trigger3 = stateno = 1310 || stateno = 1330 ;From blocking
trigger4 = stateno = 1120
trigger4 = animelemtime(4) > 0

;===========================================================================
;This is not a move, but it sets up var(1) to be 1 if conditions are right
;for a combo into a special move (used below).
;Since a lot of special moves rely on the same conditions, this reduces
;redundant logic.
[State -1, Combo condition Reset]
type = VarSet
trigger1 = 1
var(1) = 0

[State -1, Combo condition Check]
type = VarSet
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = [200,299]) || (stateno = [400,499])
trigger2 = stateno != 220
trigger2 = stateno != 250
trigger2 = stateno != 450 ;Except for sweep kick
trigger2 = movecontact
trigger3 = stateno = 1310 || stateno = 1330 ;From blocking
var(1) = 1

;===========================================================================
;This is for charge moves!
;[State -1, Charge condition Reset]
;type = VarSet
;trigger1 = command != "holdback"
;trigger1 = 1
;var(3) = 0
;
;[State -1, Charge condition Check]
;type = VarAdd
;trigger1 = command = "holdback"
;trigger1 = 1
;v = 3
;value = 1
;
;[State -1, Charge condition Reset]
;type = VarSet
;trigger1 = command != "holddown"
;trigger1 = 1
;var(4) = 0
;
;[State -1, Charge condition Check]
;type = VarAdd
;trigger1 = command = "holddown"
;trigger1 = 1
;v = 4
;value = 1

;---------------------------------------------------------------------------
;Fast Kung Fu Palm (1/3 super bar)
;[State -1, Fast Kung Fu Palm]
;type = ChangeState
;value = 1020
;triggerall = command = "BF_z"
;trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Strong Kung Fu Palm
;[State -1, Strong Kung Fu Palm]
;type = ChangeState
;value = 1010
;triggerall = command = "BF_y"
;trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Light Kung Fu Palm
;[State -1, Light Kung Fu Palm]
;type = ChangeState
;value = 1000
;triggerall = command = "BF_x"
;trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Heavy Ryu Geki Ken (1/3 super bar)
;[State -1, Heavy Ryu Geki Ken]
;type = ChangeState
;value = 1220
;triggerall = command = "QCF_z"
;trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Light Ryu Geki Ken
[State -1, Light Ryu Geki Ken]
type = ChangeState
value = 1040
triggerall = command = "FB_x"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Light Ryu Geki Ken
[State -1, Light Ryu Geki Ken]
type = ChangeState
value = 1040
triggerall = command = "FB_y"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Light Ryu Geki Ken
[State -1, Light Ryu Geki Ken]
type = ChangeState
value = 1040
triggerall = command = "FB_z"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Heavy Ryu Geki Ken
[State -1, Heavy Ryu Geki Ken]
type = ChangeState
value = 1090
triggerall = command = "BF_t"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Heavy Ryu Geki Ken
[State -1, Heavy Ryu Geki Ken]
type = ChangeState
value = 1020
triggerall = command = "BF_z"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Medium Ryu Geki Ken
[State -1, Medium Ryu Geki Ken]
type = ChangeState
value = 1010
triggerall = command = "BF_y"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Light Ryu Geki Ken
[State -1, Light Ryu Geki Ken]
type = ChangeState
value = 1000
triggerall = command = "BF_x"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Light Ryu Geki Ken
[State -1, Light Ryu Geki Ken]
type = ChangeState
value = 1070
triggerall = command = "BF_c"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Light Ryu Geki Ken
[State -1, Light Ryu Geki Ken]
type = ChangeState
value = 1060
triggerall = command = "BF_b"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Light Ryu Geki Ken
[State -1, Light Ryu Geki Ken]
type = ChangeState
value = 1050
triggerall = command = "BF_a"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Kanohi
[State -1, Kanohi]
type = ChangeState
value = 900
triggerall = statetype != A
triggerall = command = "mask" && command != "holdback"
triggerall = var(9) >= 500
trigger1 = var(1)

;---------------------------------------------------------------------------
;Kanohi
[State -1, Kanohi]
type = ChangeState
value = 920
triggerall = statetype != A
triggerall = command = "mask" && command = "holdback"
triggerall = var(9) >= 500
trigger1 = var(1)

;---------------------------------------------------------------------------
;High Kung Fu Blocking (High)
;[State -1, High Kung Fu Blocking High]
;type = ChangeState
;value = 1300
;triggerall = command = "QCB_x"
;trigger1 = ctrl
;trigger1 = statetype != A
;trigger2 = stateno = 1310 || stateno = 1330
;trigger2 = time > 0

;;---------------------------------------------------------------------------
;;High Kung Fu Blocking (Low)
;[State -1, High Kung Fu Blocking Low]
;type = ChangeState
;value = 1320
;triggerall = command = "blocking"
;triggerall = command = "holddown"
;trigger1 = ctrl
;trigger1 = statetype != A
;trigger2 = stateno = 1310 || stateno = 1330
;trigger2 = time > 0
;
;;---------------------------------------------------------------------------
;;High Kung Fu Blocking (Air)
;[State -1, High Kung Fu Blocking Low]
;type = ChangeState
;value = 1340
;triggerall = command = "blocking"
;triggerall = command != "holdup"
;triggerall = command != "holddown"
;trigger1 = ctrl
;trigger1 = statetype = A
;trigger2 = stateno = 1350
;trigger2 = time > 0

;---------------------------------------------------------------------------
;Far Kung Fu Zankou
[State -1, Far Kung Fu Zankou]
type = ChangeState
value = 1420
triggerall = command = "upper_c"
triggerall = power >= 330
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Light Kung Fu Zankou
[State -1, Light Kung Fu Zankou]
type = ChangeState
value = 1400
triggerall = command = "upper_a"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Strong Kung Fu Zankou
[State -1, Strong Kung Fu Zankou]
type = ChangeState
value = 1410
triggerall = command = "upper_b"
trigger1 = var(1) ;Use combo condition (above)

;===========================================================================
;---------------------------------------------------------------------------
;Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Run Back
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;SJ/HH
[State -1, Sup Jump]
type = ChangeState
value = 46
trigger1 = command = "SJ"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Throw
[State -1, Throw]
type = ChangeState
value = 800
triggerall = command = "throw"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = [200,250]
trigger2 = time < 4

;===========================================================================
;---------------------------------------------------------------------------
;Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = command = "x"
triggerall = command != "holddown"
triggerall = statetype != A
trigger1 = ctrl ;|| (stateno=[100,101])
trigger2 = stateno = 200
trigger2 = time > 6

;---------------------------------------------------------------------------
;Stand Medium Punch
[State -1, Stand Medium Punch]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "holddown"
triggerall = statetype != A
trigger1 = ctrl ;|| (stateno=[100,101])
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6

;---------------------------------------------------------------------------
;Stand Heavy Punch
[State -1, Stand Heavy Punch]
type = ChangeState
value = 220
triggerall = command = "z"
triggerall = command != "holddown"
triggerall = statetype != A
trigger1 = ctrl ;|| (stateno=[100,101])
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6

;---------------------------------------------------------------------------
;Stand Light Kick
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = statetype != A
trigger1 = ctrl ;|| (stateno=[100,101])
trigger2 = (stateno = 200) && time > 7
trigger3 = (stateno = 230) && time > 9

;---------------------------------------------------------------------------
;Standing Medium Kick
[State -1, Standing Medium Kick]
type = ChangeState
value = 240
triggerall = command = "b"
triggerall = command != "holddown"
triggerall = statetype != A
trigger1 = ctrl ;|| (stateno=[100,101])
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6

;---------------------------------------------------------------------------
;Standing Heavy Kick
[State -1, Standing Heavy Kick]
type = ChangeState
value = 250
triggerall = command = "c"
triggerall = command != "holddown"
triggerall = statetype != A
trigger1 = ctrl ;|| (stateno=[100,101])
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6

;---------------------------------------------------------------------------
;Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Punch
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl ;|| (stateno=[100,101])
trigger2 = (stateno = 400)
trigger2 = (time > 6) || (movecontact)

;---------------------------------------------------------------------------
;Crouching Medium Punch
[State -1, Crouching Medium Punch]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = statetype != A
;trigger1 = statetype = C
trigger1 = ctrl ;|| (stateno=[100,101])
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Crouching Heavy Punch
[State -1, Crouching Heavy Punch]
type = ChangeState
value = 420
triggerall = command = "z"
triggerall = command = "holddown"
triggerall = statetype != A
;trigger1 = statetype = C
trigger1 = ctrl ;|| (stateno=[100,101])
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Crouching Light Kick
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = command = "a"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl ;|| (stateno=[100,101])
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Crouching Strong Kick
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl ;|| (stateno=[100,101])
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Crouching Heavy Kick
[State -1, Crouching Heavy Kick]
type = ChangeState
value = 450
triggerall = command = "c"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl ;|| (stateno=[100,101])
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Jump Light Punch
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact

;---------------------------------------------------------------------------
;Jump Heavy Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 625
triggerall = command = "z"
trigger1 = statetype = A
trigger1 = ctrl
trigger1 = anim != 41 && anim != 44
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact
trigger3 = stateno = 1350 ;Air blocking

;---------------------------------------------------------------------------
;Jump Heavy Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 620
triggerall = command = "z"
trigger1 = statetype = A
trigger1 = ctrl
trigger1 = (anim = 41) || (anim = 44)
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact

;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Jump Strong Kick
[State -1, Jump Strong Kick]
type = ChangeState
value = 640
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact

;---------------------------------------------------------------------------
;Jump Strong Kick
[State -1, Jump Strong Kick]
type = ChangeState
value = 650
triggerall = command = "c"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact

